<?php

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
Route::get('/', 'Auth\LoginController@showLoginForm');
Auth::routes();
Route::get('home', 'HomeController@index')->name('home');
/*Route::group(['middleware'=>['role:super-admin|moderador|editor']],function(){
    Route::resource('usuarios','UserController');
});*/
Route::get('usuarios','UserController@index' )->name('index');
Route::get('crearUsuario','UserController@crearUsuario' )->name('crearUsuario');
Route::post('crearUsuario','UserController@guardarUsuario' )->name('guardarUsuario');
Route::get('/EditarUsuario.{id}', 'UserController@EditarUsuario')->name('EditarUsuario');
Route::post('guardarEditar', 'UserController@guardarEditar')->name('guardarEditar');

Route::post('login','Auth\LoginController@login')->name('login');
Route::post('logout','Auth\LoginController@logout')->name('logout');
Route::get('cliente','ClienteController@index' )->name('index');
Route::get('buscarCliente','ClienteController@buscar')->name('buscar');
Route::get('/direcciones.{codCliente}', 'ClienteController@direcciones')->name('direcciones');
Route::post('guardar', 'ClienteController@guardar')->name('guardar');
Route::get('salasAsignadas','ClienteController@salasAsignadas' )->name('salasAsignadas');
Route::get('/subfamilia.{id}', 'ClienteController@subfamilia')->name('subfamilia');
Route::get('/terminar.{id}', 'ClienteController@terminar')->name('terminar');
Route::get('/producto.{grupo1}.{docentry2}', 'ClienteController@producto')->name('producto');
Route::get('buscarProducto','ClienteController@buscarProd')->name('buscarProd');
Route::post('guardarStock', 'ClienteController@guardarStock')->name('guardarStock');
Route::get('reporte','ReporteController@index')->name('index');
Route::get('/listaStock.{docentry}', 'ReporteController@listaStock')->name('listaStock');
Route::get('reporteGeneral','ReporteController@reporteGeneral')->name('reporteGeneral');
Route::get('/listaSala.{id}', 'ReporteController@listaSala')->name('listaSala');
Route::get('buscarMes','ReporteController@buscarMes')->name('buscarMes');
Route::get('informeAlcance', 'HomeController@informeAlcance')->name('informeAlcance');
//Sorteo
Route::get('sorteo','SorteoController@index')->name('index');
Route::post('guardarSorteo', 'SorteoController@guardarSorteo')->name('guardarSorteo');
Route::get('imprimir','SorteoController@imprimir')->name('imprimir');
Route::get('/sorteoImprimir.{docentry}', 'SorteoController@sorteoImprimir')->name('sorteoImprimir');
Route::get('/darImprimir.{idsorteo}', 'SorteoController@darImprimir')->name('darImprimir');
//Consignaciones
Route::get('consignacion','ConsignacionController@index')->name('index');
Route::get('registrarConsignacion','ConsignacionController@registrarConsignacion')->name('registrarConsignacion');
Route::post('guardarConsignacion','ConsignacionController@guardarConsignacion')->name('guardarConsignacion');
Route::get('/autoCompletar.{cliente}','ConsignacionController@autoCompletar')->name('autoCompletar');
Route::get('/autoCompletarCod.{cliente}','ConsignacionController@autoCompletarCod')->name('autoCompletarCod');
Route::get('/direccionCliente.{codCliente}','ConsignacionController@direccionCliente')->name('direccionCliente');
Route::get('/autoCompletarProd.{codProd}','ConsignacionController@autoCompletarProd')->name('autoCompletarProd');
Route::get('/autoCompletarProdDesc.{codProd}','ConsignacionController@autoCompletarProdDesc')->name('autoCompletarProdDesc');
Route::get('/buscarConsig.{docentry}','ConsignacionController@buscarConsig')->name('buscarConsig');
Route::get('listaInventario','ConsignacionController@listaInventario' )->name('listaInventario');
Route::get('/subfamiliaDpp.{id}', 'ConsignacionController@subfamiliaDpp')->name('subfamiliaDpp');
Route::get('reporteConsignacion','ConsignacionController@reporteConsignacion')->name('reporteConsignacion');
Route::get('/detalleConsignacion.{id}','ConsignacionController@detalleConsignacion')->name('detalleConsignacion');
Route::get('/detalle.{id}','ConsignacionController@detalle')->name('detalle');
Route::post('agregarProdConsignacion','ConsignacionController@agregarProdConsignacion')->name('agregarProdConsignacion');
Route::post('agregarProdConsignacion','ConsignacionController@agregarProdConsignacion')->name('agregarProdConsignacion');
Route::post('actualizacionDetalle','ConsignacionController@actualizacionDetalle')->name('actualizacionDetalle');
Route::get('/buscarDetalleConsig.{idDetalle}','ConsignacionController@buscarDetalleConsig')->name('buscarDetalleConsig');
Route::get('/eliminarProdutcoConsig.{idDetalle}','ConsignacionController@eliminarProdutcoConsig')->name('eliminarProdutcoConsig');

Route::get('/habilitarSala.{id}', 'ReporteController@habilitarSala')->name('habilitarSala');
Route::post('actualizarFecha','ReporteController@actualizarFecha')->name('actualizarFecha');
//Route::get('listacliente','ClienteController@listacliente' )->name('listacliente');
//Route::get('/direcciones.{codCliente}', 'ClienteController@direcciones')->name('direcciones');
//Route::get('cliente/buscador','ClienteController@buscador');
//Route::get('buscarCliente.{id}','ClienteController@buscar')->name('buscar');
//Route::post('guardar', 'ClienteController@guardar')->name('guardar');
//Route::get('listaSala','ClienteController@indexSala' )->name('indexSala');
//Route::get('/subFamilia.{id}', 'ClienteController@subFamilia')->name('subFamilia');
//Route::get('/producto.{id}.{idRDir}', 'ClienteController@producto')->name('producto');
//Route::post('guardarStock', 'ClienteController@guardarStock')->name('guardarStock');
//Route::resource('empleados','EmpleadoController');
