@extends('layouts.plantilla')
@section('style')
<style>
body{
    margin: 0;
    padding: 0;
}
.fondo{
    background-image:url('img/bellcosImg.png');
    width: 100%;
    height: 100;
    background-size:cover ;
    background-position: center;
}

</style>
<meta name="csrf-token" content="{{ csrf_token() }}" />
@endsection
@section('content')
<div  class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2>Sorteo</h2>
        @if(session()->has('msj'))
        <div class="alert alert-success" role="alert">{{session('msj')}}</div>
        @endif
        @if(session()->has('error'))
        <div class="alert alert-danger" role="alert">{{session('error')}}</div>
        @endif
    </div>
</div>
<br>
<div class="row wrapper border-bottom white-bg page-heading">
    <br>
    <div class="row">
        <!--    <form action="{{route('guardarSorteo')}}" method="POST">
@csrf
         {!! csrf_field()!!}-->

         <input type="hidden" name="_token" id="token" value="{{ csrf_token() }}">
         <input type="hidden" id="ci" name="ci" value="0" >
            <div class="col-lg-12">
                <div class="col-lg-4">
                   
                    <label>Ingresar Nombre del Cliente</label>
                    <div class="form-group">
                        <input type="text" id="nombre" name="nombre" class="form-control" placeholder="Nombre del cliente" required>
                    </div>
                     <label>Ciudad</label>
                    <select class="form-control m-b" id="codciudad"  name="codciudad" required>
                        <option value="">---Selecciona una Opcion---</option>
                        @foreach($ciudad as $item)
                        <option value="{{$item->codciudad}}">{{$item->ciudad}}</option>
                        @endforeach
                    </select>
                    <label>Tipo de Paquetes</label>
                    <select class="form-control m-b" id="paquete"  name="paquete" required>
                        <option value="">---Selecciona una Opcion---</option>
                        @foreach($paquete as $item)
                        <option value="{{$item->idpaquete}}">{{$item->paquete}}- Precio: {{$item->precio}}BS</option>
                        @endforeach
                    </select>
                    <label>Ingresar Cantidad</label>
                    <div class="form-group">
                        <input type="text" id="cant" name="cant" class="form-control" placeholder="Ingrese Cantidad" required>
                    </div>
                   
                    
                    <label>Observacion</label>
                    <div class="form-group">
                        <textarea class="form-control" id="observacion" name="observacion"rows="3" placeholder="Ingrese Observacion"></textarea>
                    </div>
                </div>

            </div>
            <br>
            <div class="col-lg-2">
                <button type="submit" onclick="enviardatos()" class="btn btn-primary block full-width m-b">Guardar</button>
            </div>
       <!-- </form> -->
    </div>
</div>
<br>
<div class="row wrapper border-bottom white-bg page-heading">
    <br>
    <div class="row">
        <br>
        <div class="col-lg-12">
            <br>
            <div class="ibox float-e-margins">
                <div class="ibox-title">
                    <h5>Listado de Cliente</h5>
                    <div class="ibox-tools">
                        <a class="collapse-link">
                            <i class="fa fa-chevron-up"></i>
                        </a>
                        <a class="dropdown-toggle" data-toggle="dropdown" href="#">
                            <i class="fa fa-wrench"></i>
                        </a>
                        <ul class="dropdown-menu dropdown-user">
                            <li><a href="#">Config option 1</a>
                            </li>
                            <li><a href="#">Config option 2</a>
                            </li>
                        </ul>
                        <a class="close-link">
                            <i class="fa fa-times"></i>
                        </a>
                    </div>
                </div>
                <div class="ibox-content">

                    <div class="table-responsive">
                        <table class="table table-striped table-bordered table-hover "  >
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Cliente</th>
                                     <th>Ciudad</th>
                                    <th>Tipo de Paquete</th>
                                    <th>Cantidad</th>
                                    <th>Precio (Bs)</th>
                                    <th>Total (Bs)</th>
                                    <th>Impresion</th>
                                    <th>Observacion</th>
                                    <th>Opcion</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($sorteo as $item)
                                <tr>
                                    <td>{{$item->idSorteo}}</td>
                                    <td>{{$item->nombre}}</td>
                                    <td>{{$item->ciudad}}</td>
                                    <td>{{$item->paquete}}</td>
                                    <td>{{$item->cantidad}}</td>
                                    <td>{{$item->precio}} Bs</td>
                                    <td>{{$item->total}} Bs</td>
                                    @if($item->imprimir == 0)
                                    <td>No se Imprimio</td>
                                    @else
                                    <td>Impreso</td>
                                    @endif
                                    <td>{{$item->observacion}}</td>
                                    @can('delete users')
                                    <td><a href="{{route('sorteoImprimir',$item->idSorteo)}}" class="btn btn-primary">Imprimir</a></td>
                                    @endcan
                                </tr>
                                @endforeach
                            </tbody>
                            <tfoot>
                                <tr>
                                 <th>#</th>
                                    <th>Cliente</th>
                                     <th>Ciudad</th>
                                    <th>Tipo de Paquete</th>
                                    <th>Cantidad</th>
                                    <th>Precio (Bs)</th>
                                    <th>Total (Bs)</th>
                                    <th>Impresion</th>
                                    <th>Observacion</th>
                                    <th>Opcion</th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>
@endsection


@section('script2')
<script src="js/plugins/dataTables/datatables.min.js"></script>
<script src="js/sorteo5.js"></script>
@endsection
@section('script')
<script>
    $(document).ready(function() {
        $('.dataTables-example').DataTable({
            pageLength: 25,
            responsive: true,
            dom: '<"html5buttons"B>lTfgitp',
            buttons: [{
                    extend: 'copy'
                },
                {
                    extend: 'csv'
                },
                {
                    extend: 'excel',
                    title: 'ExampleFile'
                },
                {
                    extend: 'pdf',
                    title: 'ExampleFile'
                },

                {
                    extend: 'print',
                    customize: function(win) {
                        $(win.document.body).addClass('white-bg');
                        $(win.document.body).css('font-size', '10px');

                        $(win.document.body).find('table')
                            .addClass('compact')
                            .css('font-size', 'inherit');
                    }
                }
            ]

        });

    });
</script>

@endsection
