@extends('layouts.plantilla')
@section('content')
<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2>Detalle Consignacion</h2>
        @foreach($clientedir as $item)
        <h3>Cliente: {{$item->paterno}} - Dir: {{$item->direcciones}}</h3>
        @endforeach
        <button type="button" class="btn btn-warning btn-xs" data-toggle="modal" data-target="#myModal5">Agregar</button>
        <br>
        @if(session()->has('msj'))
        <div class="alert alert-success" role="alert">{{session('msj')}}</div>
        @endif
        @if(session()->has('error'))
        <div class="alert alert-danger" role="alert">{{session('error')}}</div>
        @endif

    </div>
</div>
<br>
<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-title">
                    <h5>Listado de Inventario DPP</h5>
                    <div class="ibox-tools">
                        <a class="collapse-link">
                            <i class="fa fa-chevron-up"></i>
                        </a>
                        <a class="dropdown-toggle" data-toggle="dropdown" href="#">
                            <i class="fa fa-wrench"></i>
                        </a>
                        <ul class="dropdown-menu dropdown-user">
                            <li><a href="#">Config option 1</a>
                            </li>
                            <li><a href="#">Config option 2</a>
                            </li>
                        </ul>
                        <a class="close-link">
                            <i class="fa fa-times"></i>
                        </a>
                    </div>
                </div>
                <div class="ibox-content">

                    <div class="table-responsive">
                        <table class="table table-striped table-bordered table-hover dataTables-example">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Cod Producto</th>
                                    <th>Descripcion</th>
                                    <th>Stock Inicial</th>
                                    <th>Acciones</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($detalleConsignacion as $item)
                                <tr class="gradeX">
                                    <td>{{$c++}}</td>
                                    <td>{{$item->codProducto}} </td>
                                    <td>{{$item->descripcion}}</td>
                                    <td class="center">{{$item->cantidad}}</td>
                                    <td class="center"> <button type="button"  onclick="abrirModalUpdate('{{$item->idDetalle}}')"  class="btn btn-primary btn-xs" data-toggle="modal" data-target="#myModal6">Editar</button>
                                    <a href="{{route('eliminarProdutcoConsig',$item->idDetalle)}}" class="btn btn-danger btn-xs">Eliminar</a></td>

                                </tr>
                                @endforeach
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th>#</th>
                                    <th>Cod Producto</th>
                                    <th>Descripcion</th>
                                    <th>Stock Inicial</th>
                                    <th>Acciones</th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>

<!-- MODAL -->
<div class="modal inmodal fade" id="myModal5" tabindex="-1" role="dialog" aria-hidden="true">
    <form action="{{url('agregarProdConsignacion')}}" method="POST">
        @csrf
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
                    <h4 class="modal-title">Agregar Nuevo Producto</h4>
                </div>
                <div class="modal-body">

                    <div class="row">
                        <div class="col-lg-12">
                            <br>
                            <div class="col-lg-4">
                            <input type="hidden" name="docentry" value="{{$clientedir[0]->docentry}}">
                                <label>Codigo Producto</label>
                                <div class="form-group">
                                    <input autocomplete="off" type="text" id="txtcodProd" name="codProd" class="form-control autocompletar3" placeholder="Cod producto">
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <label>Nombre Producto</label>
                                <div class="form-group">
                                    <input autocomplete="off"  type="text" id="txtNomProd" name="nomProd" class="form-control autocompletar4" placeholder="Nombre Producto">
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <label>Stock Inicial</label>
                                <div class="form-group">
                                    <input autocomplete="off"  type="text" id="txtCantidad" name="cantidad" class="form-control" placeholder="Cantidad">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-white" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Aadir</button>
                </div>
            </div>
        </div>
    </form>
</div>

<!-- MODAL ACTUALIZACION -->
<div class="modal inmodal fade" id="myModal6" tabindex="-1" role="dialog" aria-hidden="true">
    <form action="{{url('actualizacionDetalle')}}" method="POST">
        @csrf
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
                    <h4 class="modal-title">Actualizar Producto</h4>
                </div>
                <div class="modal-body">

                    <div class="row">
                        <div class="col-lg-12">
                            <br>
                            <div class="col-lg-4">
                            <input type="hidden" id="idconsig" name="idconsig" >
                            <input type="hidden" id="idDetalle" name="idDetalle" >
                                <label>Codigo Producto</label>
                                <div class="form-group">
                                    <input autocomplete="off" type="text" id="txtcodProd2" name="codProd2" class="form-control autocompletar3" placeholder="Cod producto" readonly>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <label>Nombre Producto</label>
                                <div class="form-group">
                                    <input autocomplete="off"  type="text" id="txtNomProd2" name="nomProd2" class="form-control autocompletar4" placeholder="Nombre Producto" readonly>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <label>Stock Inicial</label>
                                <div class="form-group">
                                    <input autocomplete="off"  type="text" id="txtCantidad2" name="cantidad2" class="form-control" placeholder="Cantidad">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-white" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Actualizar</button>
                </div>
            </div>
        </div>
    </form>
</div>


@endsection
@section('script2')
<script src="js/plugins/dataTables/datatables.min.js"></script>
<script src="js/inventarioJs/autoCompletar2.js"></script>
<script src="js/inventarioJs/agregarProd2.js"></script>
@endsection
@section('script')
<script>
    $(document).ready(function() {
        $('.dataTables-example').DataTable({
            pageLength: 25,
            responsive: true,
            dom: '<"html5buttons"B>lTfgitp',
            buttons: [{
                    extend: 'copy'
                },
                {
                    extend: 'csv'
                },
                {
                    extend: 'excel',
                    title: 'ExampleFile'
                },
                {
                    extend: 'pdf',
                    title: 'ExampleFile'
                },

                {
                    extend: 'print',
                    customize: function(win) {
                        $(win.document.body).addClass('white-bg');
                        $(win.document.body).css('font-size', '10px');

                        $(win.document.body).find('table')
                            .addClass('compact')
                            .css('font-size', 'inherit');
                    }
                }
            ]

        });

    });
</script>

@endsection
