@extends('layouts.plantilla')
@extends('layouts.plantilla')
@section('content')
<form action="{{route('guardarStock')}}" method="POST">
    @csrf
    <div class="row wrapper border-bottom white-bg page-heading">
        <div class="col-lg-10">
            <h2>Productos</h2>
            @foreach($clientedir as $item)
        <h3>Cliente: {{$item->paterno}} - Dir: {{$item->direcciones}} - {{$item->opcion}} </h3>
        @endforeach
            <input type="hidden" name="idEDir" value="{{$docentry}}">
            <input type="hidden" name="prod" value="{{$prod}}">
            <input type="hidden" name="posicion" value="{{$posicion}}">
        </div>
    </div>
    <br>
    <div class="row wrapper border-bottom white-bg page-heading">
        <div class="row">
            <div class="col-lg-4">
                <br>
                <div class="col-lg-4">
                    <button type="submit" class="btn btn-primary block full-width m-b">Guardar</button>
                </div>
            </div>
            <div class="col-lg-12">
                <br>
                <div class="ibox float-e-margins">
                    <div class="ibox-title">
                        <h5>Listado de Cliente</h5>
                        <div class="ibox-tools">
                            <a class="collapse-link">
                                <i class="fa fa-chevron-up"></i>
                            </a>
                            <a class="dropdown-toggle" data-toggle="dropdown" href="#">
                                <i class="fa fa-wrench"></i>
                            </a>
                            <ul class="dropdown-menu dropdown-user">
                                <li><a href="#">Config option 1</a>
                                </li>
                                <li><a href="#">Config option 2</a>
                                </li>
                            </ul>
                            <a class="close-link">
                                <i class="fa fa-times"></i>
                            </a>
                        </div>
                    </div>
                    <div class="ibox-content">

                        <div class="table-responsive">
                            <table class="table table-striped table-bordered table-hover dataTables">
                                <thead>
                                    <tr>
                                        <th>Codigo</th>
                                        <th>Producto</th>
                                        <th>Codigo de Barra</th>
                                        <th>Stock</th>
                                        <th>observacion</th>
                                        <th>Ingresado</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($producto as $item)
                                    <tr class="gradeX">
                                        <td>{{$item->codigo}}</td>
                                        <td>{{$item->codigo2}} </td>
                                        <td>{{$item->grupo2}} </td>
                                        <td class="center"> <input type="text" id="cursor" name="stock[]" class="form-control" onchange="return validanumero(this)" placeholder="Ingrese stock" value="0"></td>
                                        <td class="center"><textarea name="textarea[]" rows="2" cols="20" >{{$valores2[$item->codigo]}}</textarea></td>
                                        <td>{{$valores[$item->codigo]}} </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                                <tfoot>
                                    <tr>
                                    <th>Codigo</th>
                                        <th>Producto</th>
                                        <th>Codigo de Barra</th>
                                        <th>Stock</th>
                                        <th>observacion</th>
                                        <th>Ingresado</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
</form>
<script>
function validanumero(elemento){
    if(elemento.value<=0){

    }else{
          if (!/^([0-9])*$/.test(elemento.value)){
              alert("Ingrese solo numeros");
              elemento.value = 0;
          }
    }

}
</script>
@endsection


@section('script2')
<script src="js/plugins/dataTables/datatables.min.js"></script>
@endsection
@section('script')

<script>
    $(document).ready(function() {
        $('.dataTables-example').DataTable({
            pageLength: 25,
            responsive: true,
            dom: '<"html5buttons"B>lTfgitp',
            buttons: [{
                    extend: 'copy'
                },
                {
                    extend: 'csv'
                },
                {
                    extend: 'excel',
                    title: 'ExampleFile'
                },
                {
                    extend: 'pdf',
                    title: 'ExampleFile'
                },

                {
                    extend: 'print',
                    customize: function(win) {
                        $(win.document.body).addClass('white-bg');
                        $(win.document.body).css('font-size', '10px');

                        $(win.document.body).find('table')
                            .addClass('compact')
                            .css('font-size', 'inherit');
                    }
                }
            ]

        });

    });
</script>
<script>

function sf(ID){
document.getElementById(ID).focus();
}
</script>
@endsection
