@extends('layouts.plantilla')
@section('content')
<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2>Generar Ruta</h2>
        @if(session()->has('msj'))
        <div class="alert alert-success" role="alert">{{session('msj')}}</div>
        @endif
        @if(session()->has('error'))
        <div class="alert alert-danger" role="alert">{{session('error')}}</div>
        @endif
    </div>
</div>
<br>
<div class="row wrapper border-bottom white-bg page-heading">
    <br>
    <div class="row">
        <form action="{{route('buscar')}}" method="GET">
            <!-- {!! csrf_field()!!}-->
            <div class="col-lg-12">
                <div class="col-lg-2">
                    <label>Ingresar Nombre del Cliente</label>
                    <div class="form-group">
                        <input type="text" name="codCliente" class="form-control" placeholder="Nombre del cliente" value="{{$codCliente}}">
                    </div>
                </div>
                <br>
                <div class="col-lg-1">
                    <button type="submit" class="btn btn-primary block full-width m-b">Buscar</button>
                </div>
            </div>
        </form>
        <div class="col-lg-12">
            <br>
            <div class="ibox float-e-margins">
                <div class="ibox-title">
                    <h5>Listado de Cliente</h5>
                    <div class="ibox-tools">
                        <a class="collapse-link">
                            <i class="fa fa-chevron-up"></i>
                        </a>
                        <a class="dropdown-toggle" data-toggle="dropdown" href="#">
                            <i class="fa fa-wrench"></i>
                        </a>
                        <ul class="dropdown-menu dropdown-user">
                            <li><a href="#">Config option 1</a>
                            </li>
                            <li><a href="#">Config option 2</a>
                            </li>
                        </ul>
                        <a class="close-link">
                            <i class="fa fa-times"></i>
                        </a>
                    </div>
                </div>
                <div class="ibox-content">

                    <div class="table-responsive">
                        <table class="table table-striped table-bordered table-hover ">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Cliente</th>
                                    <th>CI/NIT</th>
                                    <th>Seleccionar</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($existe as $item)
                                <tr>
                                    <td>{{$item->codigo}}</td>
                                    <td>{{$item->paterno}}</td>
                                    <td>{{$item->ci_nit}}</td>
                                    <td class="center"> <a href="{{route('direcciones',$item->codigo)}}" class="btn btn-primary btn-xs">Seleccionar</a></td>
                                </tr>
                                @endforeach
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th>#</th>
                                    <th>Cliente</th>
                                    <th>CI/NIT</th>
                                    <th>Seleccionar</th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>
@endsection


@section('script2')
<script src="js/plugins/dataTables/datatables.min.js"></script>
@endsection
@section('script')
<script>
    $(document).ready(function() {
        $('.dataTables-example').DataTable({
            pageLength: 25,
            responsive: true,
            dom: '<"html5buttons"B>lTfgitp',
            buttons: [{
                    extend: 'copy'
                },
                {
                    extend: 'csv'
                },
                {
                    extend: 'excel',
                    title: 'ExampleFile'
                },
                {
                    extend: 'pdf',
                    title: 'ExampleFile'
                },

                {
                    extend: 'print',
                    customize: function(win) {
                        $(win.document.body).addClass('white-bg');
                        $(win.document.body).css('font-size', '10px');

                        $(win.document.body).find('table')
                            .addClass('compact')
                            .css('font-size', 'inherit');
                    }
                }
            ]

        });

    });
</script> 

@endsection