<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\User;
use Spatie\Permission\Models\Role;
use Illuminate\Support\Facades\DB;

class UserController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware(['permission:create users'], ['only' => ['create', 'store']]);
        $this->middleware(['permission:read users'], ['only' => 'index']);
        $this->middleware(['permission:update users'], ['only' => ['edit', 'update']]);
        $this->middleware(['permission:delete users'], ['only' => 'delete']);
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $users = User::all();
       // dd($users[0]);
        return view('usuarios.index', compact('users'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $roles = Role::all()->pluck('name', 'id');
        return view('usuarios.create', compact('roles'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //dd($request->all());
        $usuario = new User;
        $usuario->name = $request->name;
        $usuario->email = $request->email;
        $usuario->password = bcrypt($request->password);

        if ($usuario->save()) {
            // dd('ok');
            $usuario->assignRole($request->rol);
            return redirect('/usuarios');
        } else {
            dd('no ok');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $usuario = User::findOrFail($id);
        $roles = Role::all()->pluck('name', 'id');
        return view('usuarios.edit', compact('usuario', 'roles'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $usuario = User::findOrFail($id);
        $usuario->name = $request->name;
        $usuario->email = $request->email;
        if ($usuario->password != null) {
            $usuario->password = $request->password;
        }
        $usuario->syncRoles($request->rol);
        $usuario->save();

        return redirect('/usuarios');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //dd($id);
        $usuario = User::findOrFail($id);
        //eliminar el rol
        $usuario->removeRole($usuario->roles->implode('name', ','));
        //eliminar el usuario
        if ($usuario->delete()) {
            return redirect('/usuarios');
        } else {
            return response()->json([
                'mensaje' => 'Error al eliminar el usuario'
            ]);
        }
    }

    public function crearUsuario()
    {
        $roles = Role::all()->pluck('name', 'id');
        return view('usuarios.create', compact('roles'));
    }
    public function guardarUsuario(Request $request)
    {
        $usuario = new User;
        $usuario->name = $request->name;
        $usuario->email = $request->email;
        $usuario->password = bcrypt($request->password);
        $usuario->empresa = $request->ciudad;
        if ($usuario->save()) {
            // dd('ok');
            $id = DB::select('SELECT Max(id)id from users');
            DB::table('users as u')
                ->where('u.id', $id[0]->id )
                ->update(array('u.password' => bcrypt($request->password)));
            $usuario->assignRole($request->rol);
            return redirect()->to('/usuarios')->with('msj', 'Usuario Creado Exitosamente');
        } else {
            return redirect()->to('/usuarios')->with('error', 'Error al crear usuario');
        }
    }
    public function EditarUsuario($id){
        $usuario = User::findOrFail($id);
       // dd($usuario);
        $roles = Role::all()->pluck('name', 'id');
        return view('usuarios.edit', compact('usuario', 'roles'));
    }
    public function guardarEditar(Request $request){
        $usuario = User::findOrFail($request->id);
        $usuario->name = $request->name;
        $usuario->email = $request->email;
        if ($usuario->password != null) {
            $usuario->password = $request->password;
        }
        $usuario->Empresa=$request->ciudad;
        $usuario->syncRoles($request->rol);
        $usuario->save();

        return redirect()->to('/usuarios')->with('msj', 'Usuario Editado Exitosamente');
    }
}
