<?php

namespace App\Http\Controllers;

use App\Consignacione;
use App\Detalleasignacione;
use App\Detalleconsignacion;
use App\Detalleconsignacione;
use App\Detalleonsignacione;
use Carbon\Carbon;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ConsignacionController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    public function index()
    {
        $user = auth()->user()->id;
        $consignacion = DB::select("SELECT consignaciones.docentry,clientes.paterno as cod_cliente , cliente_direcciones.direcciones as id_direccion
        FROM consignaciones,cliente_direcciones,clientes
        WHERE consignaciones.cod_cliente=clientes.codigo and cliente_direcciones.id_direccion=consignaciones.id_direccion
        and cliente_direcciones.cod_cliente=clientes.codigo and consignaciones.idusuario=" . $user);
        return view('consignacion.index', compact('consignacion'));
    }
    public function registrarConsignacion()
    {
        return view('consignacion.registrar');
    }

    public function autoCompletar($cliente)
    {
        $cliente2 = DB::select('SELECT codigo,paterno FROM clientes WHERE paterno like "%' . $cliente . '%" and prop2="DPP" LIMIT 0,10');
        return response()->json($cliente2);
    }
    public function autoCompletarCod($cliente)
    {
        $cliente2 = DB::select('SELECT codigo,paterno FROM clientes WHERE codigo like "%' . $cliente . '%" and prop2="DPP" LIMIT 0,10');
        return response()->json($cliente2);
    }
    public function autoCompletarProd($codProd)
    {
        $prod = DB::select('SELECT codigo,descripcion FROM productos WHERE codigo like "%' . $codProd . '%" LIMIT 0,10');
        return response()->json($prod);
    }
    public function autoCompletarProdDesc($codProd)
    {
        $prod = DB::select('SELECT codigo,descripcion FROM productos WHERE descripcion like "%' . $codProd . '%" LIMIT 0,10');
        return response()->json($prod);
    }

    public function direccionCliente($codCliente)
    {
        $cliente2 = DB::select('SELECT id_direccion,direcciones FROM cliente_direcciones WHERE cod_cliente="' . $codCliente . '"');
        return response()->json($cliente2);
    }
    public function buscarConsig($docentry)
    {
        $consig = DB::select('SELECT consignaciones.docentry,consignaciones.cod_cliente as codCliente,consignaciones.id_direccion,cliente_direcciones.direcciones as direccion
         FROM consignaciones,cliente_direcciones
         WHERE consignaciones.cod_cliente=cliente_direcciones.cod_cliente and cliente_direcciones.id_direccion=consignaciones.id_direccion and consignaciones.docentry=' . $docentry);
        return response()->json($consig);
    }

    public function guardarConsignacion(Request $request)
    {
        //  dd($request);
        $user = auth()->user()->id;
        try {
            $codCliente = $request->codCliente;
            $idDireccion = $request->direccion;
            $cantidad = $request->cant;
            $codProd = $request->productoid;
            $existe = DB::select("SELECT count(*) as cantidad FROM consignaciones where cod_cliente='" . $codCliente . "' and id_direccion=" . $idDireccion." and idusuario=".$user);
            //dd($existe);
            if ($existe[0]->cantidad == 0) {
                $guardar = new Consignacione;
                $guardar->cod_cliente = $codCliente;
                $guardar->id_direccion = $idDireccion;
                $guardar->idusuario = $user;
                if ($guardar->save()) {
                    $id = DB::select("SELECT Max(docentry) as idUltimo FROM consignaciones ");
                    // dd($id[0]->idUltimo);
                    for ($i = 0; $i < sizeof($cantidad); $i++) {
                        $guardar = new Detalleconsignacion;
                        $guardar->idconsignacion = $id[0]->idUltimo;
                        $guardar->codProducto = $codProd[$i];
                        $guardar->cantidad = $cantidad[$i];
                        $guardar->save();
                    }
                    return redirect()->to('consignacion')->with('msj', 'Registro Exitosamente');
                } else {
                    return redirect()->to('consignacion')->with('msj', 'Error ingrese los datos correctamente');
                }
            } else {
                return redirect()->to('consignacion')->with('msj', 'Ya fue creado');
            }
        } catch (\Exception $e) {
            return redirect()->to('consignacion')->with('msj', 'Error al Guardar');
        }
    }
    public function listaInventario()
    {
        $user = auth()->user()->id;
        /*$salaRep = DB::table('asignaciones as asig')
            ->join('users as u', 'u.id', '=', 'asig.idUsuario')
            ->join('cliente_direcciones as cd', 'cd.id_direccion', '=', 'asig.id_direccion')
            ->join('clientes as c', 'c.codigo', '=', 'cd.cod_cliente')
            ->where('asig.idUsuario', '=', $user)
            ->select('asig.docentry', 'asig.fecha', 'c.paterno', 'cd.direcciones')
            ->get();*/
        $fechaini = substr(Carbon::now()->startOfMonth(), 0, 10);
        $fechafin = substr(Carbon::now()->endOfMonth(), 0, 10);
        $salaRep = DB::select('SELECT DISTINCT asignaciones.docentry,asignaciones.fecha,cliente_direcciones.direcciones,clientes.paterno,opciones.opcion
       from asignaciones,cliente_direcciones,clientes,opciones
       where cliente_direcciones.id_direccion=asignaciones.id_direccion
       and asignaciones.cod_cliente=cliente_direcciones.cod_cliente
       and clientes.codigo=cliente_direcciones.cod_cliente and opciones.idOpcion=asignaciones.idOpcion and asignaciones.idOpcion ="3"
       and ' . '"' . $fechafin . '"' . '>=asignaciones.fecha and ' . '"' . $fechaini . '"' . ' <=asignaciones.fecha and asignaciones.idUsuario=' . $user);
        /* $salaRep = DB::select('SELECT a.docentry,a.fecha,c.paterno,cd.direcciones,o.opcion
        FROM asignaciones as a, users as u, cliente_direcciones as cd, clientes as c,opciones as o
        WHERE
        a.idUsuario=u.id and cd.id_direccion=a.id_direccion and a.cod_cliente=cd.cod_cliente
        and c.codigo=cd.cod_cliente and a.estado=0 and o.idOpcion=a.idOpcion and
        a.idUsuario=' . $user);*/
        $c = 1;
        return view('consignacion.listaInventario', compact('salaRep', 'c'));
    }
    public function subfamiliaDpp($docentry)
    {
        $subfamilia = DB::select('SELECT DISTINCT productos.grupo1 FROM productos WHERE factor2="DPP" ORDER by productos.grupo1 ASC');
        $clientedir = DB::select('SELECT a.docentry,a.fecha,c.paterno,cd.direcciones,o.opcion
        FROM asignaciones as a, users as u, cliente_direcciones as cd, clientes as c,opciones as o
        WHERE a.idUsuario=u.id and cd.id_direccion=a.id_direccion and
        a.cod_cliente=cd.cod_cliente and c.codigo=cd.cod_cliente and
        a.estado=0 and o.idOpcion=a.idOpcion and a.docentry=' . $docentry);
        $docentry2 = $docentry;
        $c = 1;
        //dd($subfamilia);
        return view('cliente.subfamilia', compact('subfamilia', 'docentry2', 'c', 'clientedir'));
    }

    public function reporteConsignacion()
    {
        $user = auth()->user()->id;
        /*$salaRep = DB::table('asignaciones as asig')
            ->join('users as u', 'u.id', '=', 'asig.idUsuario')
            ->join('cliente_direcciones as cd', 'cd.id_direccion', '=', 'asig.id_direccion')
            ->join('clientes as c', 'c.codigo', '=', 'cd.cod_cliente')
            ->where('asig.idUsuario', '=', $user)
            ->select('asig.docentry', 'asig.fecha', 'c.paterno', 'cd.direcciones')
            ->get();*/
        $fechaini = substr(Carbon::now()->startOfMonth(), 0, 10);
        $fechafin = substr(Carbon::now()->endOfMonth(), 0, 10);
        $salaRep = DB::select('SELECT DISTINCT asignaciones.docentry,asignaciones.fecha,cliente_direcciones.direcciones,clientes.paterno,opciones.opcion
       from asignaciones,cliente_direcciones,clientes,opciones
       where cliente_direcciones.id_direccion=asignaciones.id_direccion
       and asignaciones.cod_cliente=cliente_direcciones.cod_cliente
       and clientes.codigo=cliente_direcciones.cod_cliente and opciones.idOpcion=asignaciones.idOpcion and asignaciones.idOpcion ="3"
       and ' . '"' . $fechafin . '"' . '>=asignaciones.fecha and ' . '"' . $fechaini . '"' . ' <=asignaciones.fecha and asignaciones.idUsuario=' . $user);
        /* $salaRep = DB::select('SELECT a.docentry,a.fecha,c.paterno,cd.direcciones,o.opcion
        FROM asignaciones as a, users as u, cliente_direcciones as cd, clientes as c,opciones as o
        WHERE
        a.idUsuario=u.id and cd.id_direccion=a.id_direccion and a.cod_cliente=cd.cod_cliente
        and c.codigo=cd.cod_cliente and a.estado=0 and o.idOpcion=a.idOpcion and
        a.idUsuario=' . $user);*/
        $c = 1;
        return view('consignacion.reporte', compact('salaRep', 'c'));
    }
    public function detalleConsignacion($id)
    {
        $user = auth()->user()->id;
        $clientedir = DB::select('select DISTINCT asignaciones.docentry,asignaciones.fecha,cliente_direcciones.direcciones,clientes.paterno ,opciones.opcion
        from asignaciones,cliente_direcciones,clientes,opciones
        where cliente_direcciones.id_direccion=asignaciones.id_direccion and asignaciones.cod_cliente=cliente_direcciones.cod_cliente and clientes.codigo=cliente_direcciones.cod_cliente and opciones.idOpcion=asignaciones.idOpcion and docentry=' .intval( $id));
       // dd($docentry);
       
        $c = 0;
        $detalleAsig=DB::select("SELECT * from asignaciones where docentry=".$id);
        
        //dd($detalleAsig);
        $idConsignacion=DB::select("SELECT * FROM consignaciones as c where  c.cod_cliente='".$detalleAsig[0]->cod_cliente."' and idusuario=".$user." and c.id_direccion=".$detalleAsig[0]->id_direccion);
        //dd($idConsignacion);
        $lista= DB::select('select 
								T1.codProducto CodCon, 
								T3.descripcion,
								T1.cantidad CantiCon,
								coalesce(T2.CantiInv,0)CantiInv,
								T1.cantidad - coalesce(T2.CantiInv,0) Reponer 
							 	from detalleconsignacions T1 
								left JOIN (	select codprod CodInv, 
														cantidad CantiInv
														from detalleasignaciones  where docentry='.$id.') T2
								on T1.codProducto=T2.CodInv
								inner join productos T3 on T1.codProducto=T3.codigo 
								where idconsignacion='.$idConsignacion[0]->docentry);
            
          
            
           
            return view('consignacion.detalleConsignacion',compact('lista','c','clientedir'));
    }
    
    public function detalle($idConsignacion)
    {
        $clientedir = DB::select('SELECT consignaciones.docentry,clientes.paterno,cliente_direcciones.direcciones FROM consignaciones,clientes,cliente_direcciones where consignaciones.cod_cliente=clientes.codigo and clientes.codigo=cliente_direcciones.cod_cliente and consignaciones.id_direccion=cliente_direcciones.id_direccion and consignaciones.docentry=' . $idConsignacion);
        $detalleConsignacion = DB::select("SELECT dc.idDetalle,dc.codProducto,dc.cantidad,p.descripcion FROM detalleconsignacions as dc ,productos as p where p.codigo=dc.codProducto and dc.idconsignacion=" . $idConsignacion);
        $c = 0;
        return view('consignacion.detalle', compact('clientedir', 'detalleConsignacion', 'c'));
    }
public function agregarProdConsignacion(Request $request)
    {
        $existe = DB::select("SELECT count(*) as cant FROM detalleconsignacions as dc WHERE dc.codProducto=" . $request->codProd . " and dc.idconsignacion=" . $request->docentry);
        //dd($existe[0]->cant);
        if ($existe[0]->cant == 0) {
            $guardar = new Detalleconsignacion;
            $guardar->idconsignacion = $request->docentry;
            $guardar->codProducto = $request->codProd;
            $guardar->cantidad = $request->cantidad;
            $guardar->save();
            return redirect()->to('/detalle.' . $request->docentry)->with('msj', 'Producto Agregado');
        } else {
            return redirect()->to('/detalle.' . $request->docentry)->with('error', 'Producto Repetido');
        }
    }
    public function actualizacionDetalle(Request $request)
    {
        $ok = DB::table('detalleconsignacions')
            ->where('idDetalle', $request->idDetalle)
            ->update(['cantidad' => $request->cantidad2]);
        if($ok==1){
            return redirect()->to('/detalle.' . $request->idconsig)->with('msj', 'Producto Actualizado');
        }else{
            return redirect()->to('/detalle.' . $request->idconsig)->with('error', 'Producto Repetido');
        }
    }
    public function eliminarProdutcoConsig($idDetalle)
    {
        $producto = DB::select("SELECT  dc.idDetalle,dc.codProducto,dc.cantidad,p.descripcion,dc.idconsignacion FROM detalleconsignacions as dc, productos as p WHERE dc.idDetalle=" . $idDetalle . " and p.codigo=dc.codProducto");
        $ok = DB::table('detalleconsignacions')->where('idDetalle', '=',$idDetalle)->delete();
       // dd($ok);
        if($ok==1){
            return redirect()->to('/detalle.' . $producto[0]->idconsignacion)->with('msj', 'Producto Eliminado');
        }else{
            return redirect()->to('/detalle.' . $producto[0]->idconsig)->with('error', 'Error al Eliminar Producto');
        }
    }

    public function buscarDetalleConsig($idDetalle)
    {
        $producto = DB::select("SELECT  dc.idDetalle,dc.codProducto,dc.cantidad,p.descripcion,dc.idconsignacion FROM detalleconsignacions as dc, productos as p WHERE dc.idDetalle=" . $idDetalle . " and p.codigo=dc.codProducto");
        return response()->json($producto);
    }
}
